/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (09/05/07)
 */

package com.ejie.p06b.xlnet;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;

import n38c.exe.N38API;
import n38i.exe.N38Excepcion;
import n38i.exe.N38ParameterException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BParametros;

/** 
 * Representa al perfil especfico de cada usuario
 */
public class P06BPerfilUsuario 
{
    
    /*
    Valores del codigo
        codigo -- > CORRECTO            = 0  El usuario est autorizado a acceder al sistema
        codigo -- > USUARIO_INVALIDO    = 1  No hay perfil de usuario
        codigo -- > CLAVE_INVALIDA      = 2  El pw no coincide
        codigo -- > ERROR_ACCESO        = 3  Cualquier problema con el acceso
        
    */
    public int codigo = 1;

    
    public static final int PRIVILEGIO_EXCEPCION  = -1;
    public static final int PRIVILEGIO_SIN_ACCESO = 99;
    public static final int PRIVILEGIO_LECTURA    = 1;
    public static final int PRIVILEGIO_ESCRITURA  = 0;
    
    public static final String IDIOMA_CAST = "es";
    public static final String IDIOMA_EUSK = "eu";
    
    public static final String IDIOMA_DEFECTO = IDIOMA_CAST;

    private boolean     cbolPerfilCargado = false;
    
    // ESTOS ATRIBUTOS SALDRAN DE LA N38
    
    //Vector donde se almacenan los permisos a los que tiene acceso el usuario.
    private String      cstrPerfilUsuario	= "";
    
    
    private String      cstrIdUsuario	= "";
    
    private String      cstrDNI       = "";    
    private String      cstrNombre    = "";
    private String      cstrApellidos = "";    
    private String      cstrIdIdioma  = IDIOMA_DEFECTO;
    private String      cstrTelefono  = "";
    private String      cstrTipoUsuario = "";       

    private Locale      clocLocale    = Locale.getDefault();
    
    private int cintNivelLog = 0;
    
	
   /**
    * Construye un objeto p06bCPerfilUsuario que representa el
    * perfil del usuario con id=astrIdUsuario de la base de datos
    * @param    astrIdUsuario  codigo del usuario cuyo perfil queremos construir
    */    
    public P06BPerfilUsuario(String astrIdUsuario) 
	{
        cstrIdUsuario = astrIdUsuario;
    }
   
   /**
    * Construye un objeto p06bCPerfilUsuario que representa el
    * perfil del usuario con id=astrIdUsuario de la base de datos y un entorno local concreto
    * @param   astrIdUsuario     id del usuario a construir
    * @param   alocLocale       entorno local         
    */     
    public P06BPerfilUsuario(String astrIdUsuario, Locale alocLocale) 
	{
        this(astrIdUsuario);
        clocLocale = alocLocale;
    }
     
     
    /*****GET*****/
    public String getIdUsuario() 
	{
        return cstrIdUsuario;
    }

    public String getPerfil() 
	{
        return cstrPerfilUsuario;
    }
    
    public int getNivelLog() 
	{
        return cintNivelLog;
    }

    public Locale getLocale() 
	{
        return clocLocale;
    }

    public String getDNI() 
	{
        return cstrDNI;    
    }
         
    public String getNombre() 
	{
        return cstrNombre;    
    }

    public String getApellidos() 
	{
        return cstrApellidos;    
    }

    public String getTelefono() 
	{
        return cstrTelefono;    
    }

    public String getIdIdioma() 
	{
        return cstrIdIdioma;    
    }

    public String getTipoUsuario() 
	{
        return cstrTipoUsuario;    
    }
    	        
    private void setIdIdioma(String astrIdIdioma) 
	{
        cstrIdIdioma = astrIdIdioma;
    }    
	
    public void cambioIdioma() 
	{
        if (getIdIdioma().equals("eu"))
            setIdIdioma("es");
        else
            setIdIdioma("eu");
        clocLocale = new Locale(cstrIdIdioma, cstrIdIdioma);                          
    }

    //DESCOMENTAR EN EJIE
    public void cargarPerfil(HttpServletRequest request, N38API n38API) throws TransformerException, P06BException 
	{
    	if(P06BParametros.get("xlnet.simulate").equals("true")){
    		//Simulo XLNET
    		cstrIdUsuario = "Usuario Simula";
    		cstrDNI = "11111111111";
    	}
    	else{
	    	Document documentoSesion = null;
			Document documentoUsuario = null;
			NodeList nodeLi = null;
			
	
				//'************ Obtener el usuario que ha iniciado sesin en LDAP***********************
				
				/*comprobamos si el usuario que ha hecho login  tiene acceso a la funcin cuyo uid es P06B-FN-0001*/
		 		documentoUsuario =n38API.n38ItemObtenerAutorizacion(P06BConstantes.P06B_FUNCION_ACCESO);
				
		 		String filtro="//elementos";  	
				nodeLi=XPathAPI.selectNodeList(documentoUsuario, filtro);
				
				if(nodeLi.getLength()==0){ 
					P06BLog.send(0,this,"P06B - El usuario no est identificado en XLNET");
					throw new P06BException(new Exception("User Non identifier"),P06BErrores.P06B_ERROR_0001);
				}
				else	
				{
					P06BLog.send(2,this,"P06B - El usuario s est identificado en XLNET");
				}
				
				documentoSesion = n38API.n38ItemSesion();
		 
				//Obtengo el nodo que contiene la informacion del DNI
				String lFiltro ="//elementos/elemento/parametro[@id=\"dni\"]/valor/text()"; 
				
				nodeLi = XPathAPI.selectNodeList(documentoSesion,lFiltro);
				
				String cstrdni = nodeLi.item(0).getNodeValue();
				
				
				String[] varLogin;
				try {
					if (n38API.n38ItemSesion("n38perfiles")!=null) {
						varLogin = n38API.n38ItemSesion("n38perfiles");
						for (int i = 0 ; i < varLogin.length; i++) {
							if (varLogin[i].toString().equals(P06BConstantes.P06B_PERFIL_SEGUROS)){
								cstrPerfilUsuario = "Seguros";
								i = varLogin.length; 
							}
				        }
					}
				} catch (N38ParameterException e) {
					// TODO Auto-generated catch block
					P06BLog.send(0,this.getClass().getName(),"P06B - N38ParameterException= " + e);
					e.printStackTrace();
				} catch (N38Excepcion e) {
					P06BLog.send(0,this.getClass().getName(),"P06B - N38Excepcion= " + e);			
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				
				// Obtengo los datos del usuario para cargarlos en el perfil
				documentoUsuario = n38API.n38ItemObtenerPersonas("dni="+cstrdni);
	
	
				//Obtengo el nodo que contiene la informacion del ID
				lFiltro ="//elementos/elemento/parametro[@id=\"uid\"]/valor/text()"; 
		        	nodeLi = XPathAPI.selectNodeList(documentoUsuario,lFiltro);
	
				if (nodeLi.getLength()>0)
					cstrIdUsuario = nodeLi.item(0).getNodeValue();
	
			
				//Obtengo el nodo que contiene la informacion del idioma
				lFiltro ="//elementos/elemento/parametro[@id=\"n38idioma\"]/valor/text()"; 
				nodeLi = XPathAPI.selectNodeList(documentoUsuario,lFiltro);
				String idioma ="";
				if (nodeLi.getLength()>0)
					idioma = nodeLi.item(0).getNodeValue();
				if (idioma.equals("3"))
					cstrIdIdioma = "eu";
				else
					cstrIdIdioma = "es";				
	
	
				//Obtengo el nodo que contiene la informacion del tipo de usuario
				lFiltro ="//elementos/elemento/parametro[@id=\"employeeType\"]/valor/text()"; 
				nodeLi = XPathAPI.selectNodeList(documentoUsuario,lFiltro);
	
				if (nodeLi.getLength()>0)
					cstrTipoUsuario = nodeLi.item(0).getNodeValue();
	
				clocLocale = new Locale(cstrIdIdioma, cstrIdIdioma);
    	}
    }
    
    /**
     * Saca el perfil en formato string
     * @return String Informacion del perfil    
     */ 
    public String toString()
    {
        StringBuffer lstrB = new StringBuffer();
        
        lstrB.append("PROFILE[USU: " + cstrIdUsuario);
        lstrB.append("; LOC: " + clocLocale);
        lstrB.append("; PERFIL: " + cstrPerfilUsuario);
        lstrB.append("]");
        
        return lstrB.toString();

    }	
}

